<?php
if (version_compare(phpversion(), "5.3.0", ">=")  == 1)
	error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);
else
	error_reporting(E_ALL & ~E_NOTICE);

$aConf = array();
$aConf['structure']	= 'PopojiCMS';
$aConf['release'] 	= '7 Juni 2013';
$aConf['ver'] 		= '1.0';
$aConf['build'] 	= '1';
$aConf['header_inc_file'] 	= '../po-library/po-config.php';
$aConf['dir_inc'] 	= '../po-library/';	
$aConf['headerTempl'] 	= <<<EOS
<?php

\$site['structure']  	= '{$aConf['structure']}';
\$site['ver']        	= '{$aConf['ver']}';
\$site['build']      	= '{$aConf['build']}';
\$site['release']    	= '{$aConf['release']}';

\$site['title']      	= "%site_title%";
\$site['url']     	 	= "%site_url%";
\$site['adm']  		 	= "{\$site['url']}po-admin/";
\$site['con']     	 	= "{\$site['url']}po-content/";
\$site['lib']  		 	= "{\$site['url']}po-library/";

\$dir['root']        	= "%dir_root%"; 
\$dir['adm']         	= "{\$dir['root']}po-admin/";
\$dir['con']         	= "{\$dir['root']}po-content/";
\$dir['lib']         	= "{\$dir['root']}po-library/";

define('PO_DIRECTORY_PATH_ADM', \$dir['adm']);
define('PO_DIRECTORY_PATH_CON', \$dir['con']);
define('PO_DIRECTORY_PATH_LIB', \$dir['lib']);

\$db['host']          	= "%db_host%";
\$db['sock']          	= "%db_sock%";
\$db['port']          	= "%db_port%";
\$db['user']          	= "%db_user%";
\$db['passwd']			= "%db_password%";
\$db['db']				= "%db_name%";

define('DATABASE_HOST', \$db['host']);
define('DATABASE_SOCK', \$db['sock']);
define('DATABASE_PORT', \$db['port']);
define('DATABASE_USER', \$db['user']);
define('DATABASE_PASS', \$db['passwd']);
define('DATABASE_NAME', \$db['db']);

if (version_compare(phpversion(), "5.3.0", ">=")  == 1)
	error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);
else
	error_reporting(E_ALL & ~E_NOTICE);
  
if (file_exists( \$dir['root'] . 'po-install' )){
\$ret = <<<EOJ
	<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">
		<head>
			<title>PopojiCMS Installation</title>
			<link href="{\$site['url']}po-install/css/general.css" rel="stylesheet" type="text/css" />
			<link href='{\$site['url']}po-install/images/favicon.png' rel='icon' />
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
		</head>
		<body>
			<p>&nbsp;<?p>
			<div id="main">
				<div id="header"></div>
				<p>&nbsp;<?p>
				<div id="content">
					<div class="install_text">{\$site['structure']} {\$site['ver']} release {\$site['release']}</div>
					<div class="installed_pic">
						<img alt="{\$site['structure']} {\$site['ver']}" src="{\$site['url']}po-install/images/popojicms_installed.png" />
					</div>
				</div>
				<div class="installed_text">
					Anda telah berhasil menginstall PopojiCMS silahkan remove 'install' directory
				</div>
			</div>
		</body>
	</html>
EOJ;
echo \$ret;
exit();
}

?>
EOS;

	$confFirst = array();
	$confFirst['site_url'] = array(
		'name' => "Site URL",
		'ex' => "http://www.mydomain.com/path/",
		'desc' => "Url situs anda (Ingat, beri backslash dibelakang url '/')",
		'def' => "http://",
	    'def_exp' => '
			$str = "http://".$_SERVER[\'HTTP_HOST\'].$_SERVER[\'PHP_SELF\'];
		    return preg_replace("/po-install\/(index\.php$)/","",$str);',
		'check' => 'return strlen($arg0) >= 10 ? true : false;'
	);
	$confFirst['dir_root'] = array(
		'name' => "Directory root",
		'ex' => "/path/to/your/script/files/",
		'desc' => "Directory dimana PopojiCMS anda diletakan.",
	    'def_exp' => '
			$str = rtrim($_SERVER[\'DOCUMENT_ROOT\'], \'/\').$_SERVER[\'PHP_SELF\'];
		    return preg_replace("/po-install\/(index\.php$)/","",$str);',
		'check' => 'return strlen($arg0) >= 1 ? true : false;'
	);
	

	$confDB = array();
	$confDB['sql_file'] = array(
	    'name' => "SQL file",
	    'ex' => "/home/situsanda/public_html/po-install/sql/popojicms.sql",
	    'desc' => "SQL file location",
		'def' => "sql/popojicms.sql",
		'def_exp' => '
			if ( !( $dir = opendir( "sql/" ) ) )
		        return "";
			while (false !== ($file = readdir($dir)))
		        {
			    if ( substr($file,-3) != \'sql\' ) continue;
				closedir( $dir );
				return "sql/$file";
			}
			closedir( $dir );
			return "";',
		'check' => 'return strlen($arg0) >= 4 ? true : false;'
	);
	 $confDB['db_host'] = array(
		'name' => "Database host name",
		'ex' => "localhost",
		'desc' => "Your MySQL database host name here.",
		'def' => "localhost",
		'check' => 'return strlen($arg0) >= 1 ? true : false;'
	);
	$confDB['db_port'] = array(
		'name' => "Database host port number",
		'ex' => "5506",
		'desc' => "Leave blank or specify MySQL Database host port number.",
		'def' => "",
		'check' => ''
	);
	$confDB['db_sock'] = array(
		'name' => "Database socket path",
		'ex' => "/tmp/mysql50.sock",
		'desc' => "Leave blank or specify MySQL Database socket path.",
		'def' => "",
		'check' => ''
	);
	$confDB['db_name'] = array(
	    'name' => "Database name",
	    'ex' => "YourDatabaseName",
	    'desc' => "Your MySQL database name here.",
	    'check' => 'return strlen($arg0) >= 1 ? true : false;'
	);
	$confDB['db_user'] = array(
		'name' => "Database user",
		'ex' => "YourName",
		'desc' => "Your MySQL database read/write user name here.",
		'check' => 'return strlen($arg0) >= 1 ? true : false;'
	);
	$confDB['db_password'] = array(
		'name' => "Database password",
		'ex' => "YourPassword",
		'desc' => "Your MySQL database password here.",
		'check' => 'return strlen($arg0) >= 0 ? true : false;'
	);

	$confGeneral = array();
	$confGeneral['site_title'] = array(
		'name' => "Site Title",
		'ex' => "The Best Community",
		'desc' => "The name of your site",
		'check' => 'return strlen($arg0) >= 1 ? true : false;'
	);
	$confGeneral['site_desc'] = array(
		'name' => "Site Description",
		'ex' => "The place to find new friends, communicate and have fun.",
		'desc' => "Meta description of your site",
		'check' => 'return strlen($arg0) >= 1 ? true : false;'
	);
	$confGeneral['site_email'] = array(
		'name' => "Site e-mail",
		'ex' => "your@email.here",
		'desc' => "Your site e-mail.",
		'check' => 'return strlen($arg0) > 0 AND strstr($arg0,"@") ? true : false;'
	);

	$aTemporalityWritableFolders = array(
		'inc',
	);






$action = isset($_REQUEST['action'])?$_REQUEST['action']:'';
$error = '';

$InstallPageContent = InstallPageContent( $error );

mb_internal_encoding('UTF-8');

echo PageHeader( $action, $error );
echo $InstallPageContent;
echo PageFooter( $action );

function InstallPageContent(&$error) {
	global $aConf, $confFirst, $confDB, $confGeneral;
        $action = isset($_REQUEST['action'])?$_REQUEST['action']:'';
	$ret = '';

	switch ($action) {

		case 'step5':
			$ret .= genMainPage();
		break;

		case 'step4':
			$errorMessage = checkConfigArray($confGeneral, $error);
			$ret .= (strlen($errorMessage)) ? genSiteGeneralConfig($errorMessage) : genInstallationProcessPage();
		break;

		case 'step3':
			$errorMessage = checkConfigArray($confDB, $error);
			$errorMessage .= CheckSQLParams();

			$ret .=  (strlen($errorMessage)) ? genDatabaseConfig($errorMessage) : genSiteGeneralConfig();
		break;

		case 'step2':
			$errorMessage = checkConfigArray($confFirst, $error);
			$ret .= (strlen($errorMessage)) ? genPathCheckingConfig($errorMessage) : genDatabaseConfig();
		break;

		case 'step1':
			$ret .= genPathCheckingConfig();
		break;

		default:
			$ret .= StartInstall();
		break;
	}

	return $ret;
}

function PageHeader($action = '', $error = '') {
	global $aConf;

	$actions = array(
		"startInstall" => "PopojiCMS Installation",
		"step1" => "Paths",
		"step2" => "Database",
		"step3" => "Config",
		"step4" => "Installation Process",
		"step5" => "Main Page",
	);

	if( !strlen( $action ) )
		$action = "startInstall";

	$activeStyle = ($action == "step5") ? 'Active' : 'Inactive';

	$iCounterCurrent = 1;
	$iCounterActive	 = 1;

	foreach ($actions as $actionKey => $actionValue) {
		if ($action != $actionKey) {
			$iCounterActive++;
		} else
			break;
	}

	if (strlen($error))
		$iCounterActive--;

	$subActions = '';
	foreach ($actions as $actionKey => $actionValue) {
		if ($iCounterActive == $iCounterCurrent) {
			$subActions .= '<div id="topActive">' . $actionValue . '</div>';
		} elseif (($iCounterActive - $iCounterCurrent) == -1) {
			$subActions .= '<img src="images/active_inactive.gif" /><div id="topInactive">' . $actionValue . '</div><img src="images/inactive_inactive.gif" />';
		} elseif (($iCounterActive - $iCounterCurrent) == 1) {
			$subActions .= '<div id="topInactive">' . $actionValue . '</div><img src="images/inactive_active.gif" />';
		} else {
			$subActions .= '<div id="topInactive">' . $actionValue . '</div>';
			if ($actionKey != "step6")
				$subActions .= '<img src="images/inactive_inactive.gif" />';
		}
		$iCounterCurrent++;
	}

	return <<<EOF
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en-US" lang="en-US">
		<head>
			<title>PopojiCMS Installation</title>
			<link href="css/general.css" rel="stylesheet" type="text/css" />
			<link href='images/favicon.png' rel='icon' />
			<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			<!--[if lt IE 7.]>
			<script defer type="text/javascript" src="js/pngfix.js"></script>
			<![endif]-->
		</head>
		<body>
			<p>&nbsp;<?p>
			<div id="main">
				<div id="topMenu{$activeStyle}">
					{$subActions}
				</div>
			<div id="header"></div>
			<div id="content">
EOF;
}

function PageFooter($action) {
	$tambahan = '';

	return <<<EOF
			</div>
		{$tambahan}
		</div>
	</body>
</html>
EOF;
}

function StartInstall() {
	global $aConf;

	return <<<EOF
<div class="install_pic">
	PopojiCMS {$aConf['ver']}.{$aConf['build']}
</div>

<div class="install_text">
	Selamat datang di PopojiCMS installation page<br />
	Click tombol berikut untuk memulai installasi.
</div>

<div class="install_button">
	<form action="{$_SERVER['PHP_SELF']}" method="post">
	<input id="button" type="image" src="images/install.gif" />
	<input type="hidden" name="action" value="step1" />
	</form>
</div>
EOF;
}

function genPathCheckingConfig($errorMessage = '') {
	global  $aConf, $confFirst;

	$currentPage = $_SERVER['PHP_SELF'];

	$error = printInstallError( $errorMessage );
	$pathsTable = createTable($confFirst);

	return <<<EOF
<div class="position">Paths Check</div>
{$error}
<div class="LeftRirght">
	<div class="clearBoth"></div>
	<div class="left">
		PopojiCMS checks general script paths.
	</div>
	<div class="right">
		<form action="{$currentPage}" method="post">
			<table cellpadding="0" cellspacing="1" width="100%" border="0" style="background-color:silver;">
				<tr class="head">
					<td>&nbsp;</td>
					<td>&nbsp;</td>
				</tr>
				{$pathsTable}
			</table>
			<div class="formKeeper">
				<input id="button" type="image" src="images/next.gif" />
				<input type="hidden" name="action" value="step2" />
			</div>
		</form>
	</div>
	<div class="clearBoth"></div>
</div>
EOF;
}

function genDatabaseConfig($errorMessage = '') {
	global $confDB;

	$currentPage = $_SERVER['PHP_SELF'];
	$DbParamsTable = createTable($confDB);

	$errors = '';
	if (strlen($errorMessage)) {
		$errors = printInstallError($errorMessage);
		unset($_POST['db_name']);
		unset($_POST['db_user']);
		unset($_POST['db_password']);
	}

	$oldDataParams = '';
	foreach($_POST as $postKey => $postValue) {
		$oldDataParams .= ('action' == $postKey || isset($confDB[$postKey])) ? '' : '<input type="hidden" name="' . $postKey . '" value="' . $postValue . '" />';
	}

	return <<<EOF
<div class="position">Database</div>
{$errors}
<div class="LeftRirght">
	<div class="clearBoth"></div>
	<div class="left">
	</div>
	<div class="right">
		<form action="{$currentPage}" method="post">
			<table cellpadding="0" cellspacing="1" width="100%" border="0" style="background-color:silver;">
				<tr class="head">
					<td>&nbsp;</td>
					<td>&nbsp;</td>
				</tr>
				{$DbParamsTable}
			</table>
			<div class="formKeeper">
				<input id="button" type="image" src="images/next.gif" />
				<input type="hidden" name="action" value="step3" />
				{$oldDataParams}
			</div>
		</form>
	</div>
	<div class="clearBoth"></div>
</div>
EOF;
}

function genSiteGeneralConfig($errorMessage = '') {
	global $confGeneral;

	$currentPage = $_SERVER['PHP_SELF'];
	$paramsTable = createTable($confGeneral);

	$errors = '';
	if (strlen($errorMessage)) {
		$errors = printInstallError($errorMessage);
		unset($_POST['site_title']);
		unset($_POST['site_email']);
		unset($_POST['notify_email']);
		unset($_POST['bug_report_email']);
	}

	$oldDataParams = '';
	foreach($_POST as $postKey => $postValue) {
		$oldDataParams .= ('action' == $postKey || isset($confGeneral[$postKey])) ? '' : '<input type="hidden" name="' . $postKey . '" value="' . $postValue . '" />';
	}

	return <<<EOF
<div class="position">Configuration</div>
{$errors}
<div class="LeftRirght">
	<div class="clearBoth"></div>
	<div class="left"></div>
	<div class="right">
		<form action="{$currentPage}" method="post">
			<table cellpadding="0" cellspacing="1" width="100%" border="0" style="background-color:silver;">
				<tr class="head">
					<td>&nbsp;</td>
					<td>&nbsp;</td>
				</tr>
				{$paramsTable}
			</table>
			<div class="formKeeper">
				<input id="button" type="image" src="images/next.gif" />
				<input type="hidden" name="action" value="step4" />
				{$oldDataParams}
			</div>
		</form>
	</div>
	<div class="clearBoth"></div>
</div>
EOF;
}

function genInstallationProcessPage($errorMessage = '') {
	global $aConf, $confFirst, $confDB, $confGeneral;

	$resRunSQL = RunSQL();

	$sForm = '';
	
	if ('done' ==  $resRunSQL) {
		$sForm = '
		<div class="formKeeper">
			<form action="' . $_SERVER['PHP_SELF'] . '" method="post">
				<input type="image" src="images/next.gif" />
				<input type="hidden" name="action" value="step5" />
			</form>
		</div>
		<div class="clearBoth"></div>';
	} else {
		$sForm = $resRunSQL . '
		<div class="formKeeper">
			<form action="' . $_SERVER['PHP_SELF'] . '" method="post">
				<input type="image" src="images/back.gif" />';
		foreach ($_POST as $sKey => $sValue) {
			if ($sKey != "action")
				$sForm .= '<input type="hidden" name="' . $sKey . '" value="' . $sValue . '" />';
		}
		$sForm .= '<input type="hidden" name="action" value="step2" />
			</form>
		</div>
		<div class="clearBoth"></div>';
		return $sForm;
	}

	foreach ($confFirst as $key => $val) {
		$aConf['headerTempl'] = str_replace ("%$key%", $_POST[$key], $aConf['headerTempl']);
	}
	foreach ($confDB as $key => $val) {
		$aConf['headerTempl'] = str_replace ("%$key%", $_POST[$key], $aConf['headerTempl']);
	}
	foreach ($confGeneral as $key => $val) {
		$aConf['headerTempl'] = str_replace ("%$key%", $_POST[$key], $aConf['headerTempl']);
	}

	$innerCode = '';
	$fp = fopen($aConf['header_inc_file'], 'w');
	if ($fp) {
		fputs($fp, $aConf['headerTempl']);
		fclose($fp);
		chmod($aConf['header_inc_file'], 0666);
		//$innerCode .='Config file telah berhasil ditulis di <strong>' . $aConf['header_inc_file'] . '</strong><br />';
	} else {
		$text = 'Warning!!! can not get write access to config file ' . $aConf['header_inc_file'] . '. Here is config file</font><br>';
		$innerCode .= printInstallError($text);
		$trans = get_html_translation_table(HTML_ENTITIES);
		$templ = strtr($aConf['headerTempl'], $trans);
		$sInnerCode .= '<textarea cols="20" rows="10" class="headerTextarea">' . $aConf['headerTempl'] . '</textarea>';
	}
	return <<<EOF
<div class="position">Process install sudah selesai</div>
<div class="LeftRirght">
	{$sForm}
</div>
EOF;
}

// check of config pages steps
function checkConfigArray($checkedArray, &$error) {

	$errorMessage = '';

	foreach ($checkedArray as $key => $value) {
		if (! strlen($value['check'])) continue;

		$funcbody = $value['check'];
		$func = create_function('$arg0', $funcbody);

		if (! $func($_POST[$key])) {
			$fieldErr = $value['name'];
			$errorMessage .= "Please, input valid data to <b>{$fieldErr}</b> field<br />";
			$error_arr[$key] = 1;
			unset($_POST[$key]);
		} else
			$error_arr[$key] = 0;

		//$config_arr[$sKey]['def'] = $_POST[$sKey];
	}

	if (strlen($errorMessage)) {
		$error = 'error';
	}

	return $errorMessage;
}

function genMainPage() {
	return <<<EOF
<script type="text/javascript">
	window.location = "../index.php";
</script>
EOF;
}

function printInstallError($text) {
	$ret = (strlen($text)) ? '<div class="error">' . $text . '</div>' : '';
	return $ret;
}

function createTable($arr) {
	$ret = '';
	$i = '';
        $error_arr = array();
	foreach($arr as $key => $value) {
		$sStyleAdd = (($i%2) == 0) ? 'background-color:#ede9e9;' : 'background-color:#fff;';

		$def_exp_text = "";
		if (strlen($value['def_exp'])) {
		    $funcbody = $value['def_exp'];
		    $func = create_function("", $funcbody);
		    $def_exp = $func();
			if (strlen($def_exp)) {
				$def_exp_text = "&nbsp;<font color=green>found</font>";
				$value['def'] = $def_exp;
			} else {
				$def_exp_text = "&nbsp;<font color=red>not found</font>";
			}
		}

		$st_err = ($error_arr[$key] == 1) ? ' style="background-color:#FFDDDD;" ' : '';

		$ret .= <<<EOF
	<tr class="cont" style="{$sStyleAdd}">
		<td>
			<div>{$value['name']}</div>
			<div>Description:</div>
			<div>Example:</div>
		</td>
		<td>
			<div><input {$st_err} size="30" name="{$key}" value="{$value['def']}" /> {$def_exp_text}</div>
			<div>{$value['desc']}</div>
			<div style="font-style:italic;">{$value['ex']}</div>
		</td>
	</tr>
EOF;
		$i ++;
	}

	return $ret;
}

function rewriteFile($code, $replace, $file) {
	$ret = '';
	$fs = filesize($file);
	$fp = fopen($file, 'r');
	if ($fp) {
		$fcontent = fread($fp, $fs);
		$fcontent = str_replace($code, $replace, $fcontent);
		fclose($fp);
		$fp = fopen($file, 'w');
		if ($fp) {
			if (fputs($fp, $fcontent)) {
				$ret .= true;
			} else {
				$ret .= false;
			}
			fclose ( $fp );
		} else {
			$ret .= false;
		}
	} else {
		$ret .= false;
	}
	return $ret;
}

function RunSQL() {
	$confDB['host']   = $_POST['db_host'];
	$confDB['sock']   = $_POST['db_sock'];
	$confDB['port']   = $_POST['db_port'];
	$confDB['user']   = $_POST['db_user'];
	$confDB['passwd'] = $_POST['db_password'];
	$confDB['db']     = $_POST['db_name'];

	$confDB['host'] .= ( $confDB['port'] ? ":{$confDB['port']}" : '' ) . ( $confDB['sock'] ? ":{$confDB['sock']}" : '' );

	$pass = true;
	$errorMes = '';
	$filename = $_POST['sql_file'];

	$vLink = @mysql_connect($confDB['host'], $confDB['user'], $confDB['passwd']);

	if( !$vLink )
		return printInstallError( mysql_error() );

	if (!mysql_select_db ($confDB['db'], $vLink))
		return printInstallError( $confDB['db'] . ': ' . mysql_error() );

    mysql_query ("SET sql_mode = ''", $vLink);

    if (! ($f = fopen ( $filename, "r" )))
    	return printInstallError( 'Could not open file with sql instructions:' . $filename  );

	//Begin SQL script executing
	$s_sql = "";
	while ($s = fgets ( $f, 10240)) {
		$s = trim( $s ); //Utf with BOM only

		if (! strlen($s)) continue;
		if (mb_substr($s, 0, 1) == '#') continue; //pass comments
		if (mb_substr($s, 0, 2) == '--') continue;
		if (substr($s, 0, 5) == "\xEF\xBB\xBF\x2D\x2D") continue;

		$s_sql .= $s;

		if (mb_substr($s, -1) != ';') continue;

		$res = mysql_query($s_sql, $vLink);
		if (!$res)
			$errorMes .= 'Error while executing: ' . $s_sql . '<br />' . mysql_error() . '<hr />';

		$s_sql = '';
	}


    fclose($f);
    
	$siteEmail = DbEscape($_POST['site_email']);
	$siteTitle = DbEscape($_POST['site_title']);
	$siteDesc = DbEscape($_POST['site_desc']);
	$siteUrlsim = "http://".$_SERVER['HTTP_HOST'];
	if ($siteEmail != '' && $siteTitle != '') {
		if (! (mysql_query("INSERT INTO `setting` (`id_setting`, `website_name`, `website_url`, `website_email`, `meta_description`, `meta_keyword`, `favicon`) VALUES('1', '{$siteTitle}', '{$siteUrlsim}', '{$siteEmail}', '{$siteDesc}', 'popojicms, website popojicms, cms indonesia, cms terbaik indonesia, cms gratis, cms gratis indonesia, alternatif cms', 'favicon.png')", $vLink)))
			$ret .= "<font color=red><i><b>Error</b>:</i> ".mysql_error($vLink)."</font><hr>";
	} else {
		$ret .= "<font color=red><i><b>Error</b>:</i> Mohon dicheck kembali site_email  atau site_title</font><hr>";
	}

    mysql_close($vLink);

    $errorMes .= $ret;

    if (strlen($errorMes)) {
    	return printInstallError($errorMes);
    } else {
    	return 'done';
    }
//    return $ret."Truncating tables finished.<br>";
}

function DbEscape($s, $isDetectMagixQuotes = true) {
    if (get_magic_quotes_gpc() && $isDetectMagixQuotes)
        $s = stripslashes ($s);
    return mysql_real_escape_string($s);
}

function CheckSQLParams() {
	$confDB['host']   = $_POST['db_host'];
	$confDB['sock']   = $_POST['db_sock'];
	$confDB['port']   = $_POST['db_port'];
	$confDB['user']   = $_POST['db_user'];
	$confDB['passwd'] = $_POST['db_password'];
	$confDB['db']     = $_POST['db_name'];

	$confDB['host'] .= ( $confDB['port'] ? ":{$confDB['port']}" : '' ) . ( $confDB['sock'] ? ":{$confDB['sock']}" : '' );

	$vLink = @mysql_connect($confDB['host'], $confDB['user'], $confDB['passwd']);

	if (!$vLink)
		return printInstallError(mysql_error());

	if (!mysql_select_db ($confDB['db'], $vLink))
		return printInstallError($confDB['db'] . ': ' . mysql_error());

	mysql_close($vLink);
}

?>